package demo.shadow_elements.step_bar;

import org.zkoss.bind.annotation.BindingParam;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.Init;
import org.zkoss.bind.annotation.NotifyChange;

import demo.shadow_elements.step_bar.StepBarModel.Step;

public class HolidayOrderViewModel {
	private StepBarModel stepBarModel;
	private boolean carAdded = false;
	@Init
	public void init() {
		stepBarModel = new StepBarModel();
		addStep("Destination", "z-icon-globe", "destination.zul");
		addStep("Accommodation", "z-icon-hotel", "accommodation.zul");
		addStep("Personal Details", "z-icon-user", "personal-details.zul");
		addStep("Payment", "z-icon-credit-card", "payment.zul");
		addStep("Enjoy Holiday", "z-icon-smile-o", "finish.zul");
		stepBarModel.getItems().addToSelection(stepBarModel.getItems().get(0));
	}
	
	@Command
	public void gotoStep(@BindingParam("step") StepBarModel.Step step) {
		stepBarModel.navigateTo(step);
	}
	
	@Command
	public void next() {
		stepBarModel.next();
	}
	
	@Command
	public void back() {
		stepBarModel.back();
	}
	
	@Command
	@NotifyChange("carAdded")
	public void addCar() {
		addStep(2, "Rent Car", "z-icon-car", "rent-car.zul");
		this.carAdded = true;
	}

	@Command
	@NotifyChange("carAdded")
	public void removeCar() {
		Step carStep = stepBarModel.getCurrent();
		stepBarModel.next();
		stepBarModel.getItems().remove(carStep);
		this.carAdded = false;
	}
	
	public StepBarModel getStepBarModel() {
		return stepBarModel;
	}

	public boolean isCarAdded() {
		return carAdded;
	}
	
	public void addStep(String label, String icon, String uri) {
		addStep(stepBarModel.getItems().size(), label, icon, uri);
	}
	
	public void addStep(int index, String label, String icon, String uri) {
		String stepsFolder = "/widgets/shadow_elements/step_bar/steps";
		stepBarModel.getItems().add(index, stepBarModel.new Step(label, icon, stepsFolder + "/" + uri));
	}
}

