package demo.server_push.websocket;

import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.CheckEvent;
import org.zkoss.zk.ui.select.SelectorComposer;
import org.zkoss.zk.ui.select.annotation.Listen;
import org.zkoss.zk.ui.sys.DesktopCtrl;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zkmax.au.websocket.WebSocketServerPush;
import org.zkoss.zkmax.ui.comet.CometServerPush;
import org.zkoss.zul.Radio;

import javax.servlet.http.HttpServletRequest;

/**
 * This controller allows toggling between websocket and comet mode. ONLY for demonstration purposes.
 * In a real application the fallback to comet will happen automatically if websockets are not available
 */
public class ServerPushCtrl extends SelectorComposer {

	@Override
	public void doAfterCompose(Component comp) throws Exception {
		super.doAfterCompose(comp);
		Desktop desktop = Executions.getCurrent().getDesktop();
		desktop.enableServerPush(true);
		DesktopCtrl desktopCtrl = (DesktopCtrl) desktop;
	}

	@Listen("onCheck=#serverPushMode")
	public void toggleWebsocket(CheckEvent event) {
		Execution execution = Executions.getCurrent();
		Desktop desktop = execution.getDesktop();
		DesktopCtrl desktopCtrl = (DesktopCtrl) desktop;

		boolean enabled = event.isChecked();
		String mode = ((Radio)event.getTarget()).getValue();

		switch (mode) {
			case "comet": {
				desktop.enableServerPush(false);
				((DesktopCtrl) desktop).enableServerPush(new CometServerPush());
				Clients.evalJavaScript("zWs.stop()");
				break;
			}
			case "websocket": {
				desktop.enableServerPush(false);
				((DesktopCtrl)desktop).enableServerPush(new WebSocketServerPush());
				String wsurl = desktop.getWebApp().getAttribute("websocketUrl").toString();
				boolean secure = ((HttpServletRequest) execution.getNativeRequest()).isSecure();
				Clients.evalJavaScript(String.format("zWs.start('%s', %s);", wsurl, secure));
				break;
			}
		}
	}
}
