package demo.popup.toast;

import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.select.SelectorComposer;
import org.zkoss.zk.ui.select.annotation.Listen;
import org.zkoss.zk.ui.select.annotation.Wire;
import org.zkoss.zkmax.ui.util.Toast;
import org.zkoss.zul.Radiogroup;
import org.zkoss.zul.Textbox;

public class ToastComposer extends SelectorComposer<Component> {

	@Wire
	private Textbox target;
	@Wire
	private Radiogroup rgType;
	@Wire
	private Radiogroup rgPosition;

	@Override
	public void doAfterCompose(Component comp) throws Exception {
		super.doAfterCompose(comp);
	}

	@Listen("onClick = #toastBtn")
	public void toastBtnClick() {
		Toast.show("You have been toasted");
	}

	@Listen("onClick = #toastCloseBtn")
	public void toastCloseBtnClick() {
		Toast.show("This toast is closable", rgType.getSelectedItem().getLabel(), null, 0, true);
	}

	@Listen("onClick = #toastPositionBtn")
	public void toastCustomBtnClick() {
		Toast.show("This toast is closable", rgType.getSelectedItem().getLabel(),
				"middle_" + rgPosition.getSelectedItem().getLabel(), 2000, false);
	}

}
