package demo.menu.dynamic_fisheye_menu;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;

public abstract class FisheyeRenderer {

	private Font font;
	private int imageSize;

	public FisheyeRenderer(int fontSize, int imageSize) {
		this.imageSize = imageSize;
		font = new Font("Courier New", Font.BOLD, fontSize);
	}

	public void draw(int leng, String name, int fontColor, int shadowColor, double angle) {
		AffineTransform transformation = AffineTransform.getTranslateInstance(imageSize / 2, imageSize / 2);
		transformation.rotate(angle / 360.0 * 2 * Math.PI);

		for(char letter : name.toCharArray()) {
			BufferedImage image = new BufferedImage(imageSize, imageSize, BufferedImage.TYPE_INT_ARGB);
			Graphics2D g2d = image.createGraphics();
			Rectangle2D bounds = font.getMaxCharBounds(g2d.getFontRenderContext());
			g2d.setTransform(transformation);
			g2d.setFont(font);
			g2d.setColor(new Color(shadowColor));
			g2d.drawString("" + letter, (int)-bounds.getWidth() / 4 + 10, (int)bounds.getHeight() / 4 + 5);
			g2d.setColor(new Color(fontColor));
			g2d.drawString("" + letter, (int)-bounds.getWidth() / 4, (int)bounds.getHeight() / 4);

			onImageRendered(image);
		}
	}
	
	protected abstract void onImageRendered(RenderedImage image);
}
