package demo.menu.color_picker_menu;

import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.InputEvent;
import org.zkoss.zk.ui.select.SelectorComposer;
import org.zkoss.zk.ui.select.annotation.Listen;
import org.zkoss.zk.ui.select.annotation.Wire;
import org.zkoss.zul.Div;

public class ColorPickerMenuController extends SelectorComposer<Component>{

	@Wire
	private Div testDiv1; 
	
	@Wire
	private Div testDiv2; 
	
	@Wire
	private Div testDiv3; 
	
	@Listen("onChange = #color1") 
	public void onColor1Updated(InputEvent event) {
		testDiv1.setStyle("background-color:" + event.getValue() + ";");
	}
	
	@Listen("onChange = #color2") 
	public void onColor2Updated(InputEvent event) {
		testDiv2.setStyle("background-color:" + event.getValue() + ";");
	}
	
	@Listen("onChange = #color3") 
	public void onColor3Updated(InputEvent event) {
		testDiv3.setStyle("background-color:" + event.getValue() + ";");
	}
}
