package demo.listbox.list_group;

import org.zkoss.bind.annotation.BindingParam;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.Init;

import demo.data.FoodData;
import demo.data.pojo.Food;
import demo.grid.grouping_model.FoodComparator;

public class ListGroupViewModel {

	private FoodGroupsModel groupModel;
	
	@Init
	public void init() {
		groupModel = new FoodGroupsModel(FoodData.getAllFoodsArray(), new FoodComparator());
		groupModel.setMultiple(true);
	}

	public FoodGroupsModel getGroupModel() {
		return groupModel;
	}

	
	@Command("selectGroup")
	public void selectGroup(@BindingParam("data") Object data) {
		if(data instanceof FoodGroupsModel.FoodGroupInfo) {
			FoodGroupsModel.FoodGroupInfo groupInfo = (FoodGroupsModel.FoodGroupInfo)data;
			int groupIndex = groupInfo.getGroupIndex() ;
			int childCount = groupModel.getChildCount(groupIndex);
			boolean added = groupModel.isSelected(groupInfo);
			for(int childIndex = 0; childIndex < childCount; childIndex++) {
				Food food = groupModel.getChild(groupIndex, childIndex);
				if(added) {
					groupModel.addToSelection(food);
				} else {
					groupModel.removeFromSelection(food);
				}
			}
		}
	}
}
