package demo.layout.column_layout;

import java.util.Set;

import org.zkoss.bind.annotation.Command;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.ListModelList;

public class ColumnLayoutViewModel {

	private static final String IMAGE_URL = "/widgets/layout/column_layout/img/blue-document.png";

	private ListModelList<ProjectInfo> leftListModel =
			createListModel("ZK Forge", "ZK Mobile", "ZK GWT", "ZK JSF", "ZK JSP");
	private ListModelList<ProjectInfo> rightListModel =
			createListModel("ZK", "ZK Studio", "ZK Spring");

	@Command
	public void addProjects() {
		moveSelection(leftListModel, rightListModel, "Please select at least one Project to add.");
	}

	@Command
	public void removeProjects() {
		moveSelection(rightListModel, leftListModel, "Please select at least one Project to remove.");
	}

	public void moveSelection(ListModelList<ProjectInfo> origin, ListModelList<ProjectInfo> destination,
							  String failMessage) {
		Set<ProjectInfo> selection = origin.getSelection();
		if (selection.isEmpty()) {
			Clients.showNotification(failMessage, "info", null, null, 2000, true);
		} else {
			destination.addAll(selection);
			origin.removeAll(selection);
		}
	}
	
	public ListModelList<ProjectInfo> getLeftListModel() {
		return leftListModel;
	}

	public ListModelList<ProjectInfo> getRightListModel() {
		return rightListModel;
	}

	private ListModelList<ProjectInfo> createListModel(String... labels) {
		ListModelList<ProjectInfo> listModelList = new ListModelList<ProjectInfo>();
		for(String label : labels) {
			listModelList.add(new ProjectInfo(label, IMAGE_URL));
		}
		listModelList.setMultiple(true);
		return listModelList;
	}
}
