package demo.input.range_slider;

import java.util.HashMap;
import java.util.Map;

import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.select.SelectorComposer;
import org.zkoss.zk.ui.select.annotation.Wire;
import org.zkoss.zkex.zul.Rangeslider;

public class RangeSliderComposer extends SelectorComposer {

	@Wire
	private Rangeslider slidermarks;

	@Override
	public void doAfterCompose(Component comp) throws Exception {
		super.doAfterCompose(comp);

		Map<Integer, String> marks = new HashMap<Integer, String>();
		marks.put(20, "20%, low");
		marks.put(50, "50%, medium");
		marks.put(80, "80%, high");
		slidermarks.setMarkScale(0);
		slidermarks.setMarks(marks);
	}
}
