package demo.input.color_picker;

import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.InputEvent;
import org.zkoss.zk.ui.select.SelectorComposer;
import org.zkoss.zk.ui.select.annotation.Listen;
import org.zkoss.zk.ui.select.annotation.Wire;
import org.zkoss.zkex.zul.Colorbox;
import org.zkoss.zul.Menu;
import org.zkoss.zul.Window;

public class ColorPickerController extends SelectorComposer<Component> {
	@Wire
	private Window win1;
	
	@Wire
	private Window win2;
	
	@Wire("#win1 #colorMenu")
	private Menu colorMenu;
	
	@Wire("#win2 #colorPicker")
	private Colorbox colorPicker;
	
	@Override
	public void doAfterCompose(Component comp) throws Exception {
		super.doAfterCompose(comp);
		
		colorMenu.setContent("#color=" + "#029BCB");
		colorPicker.setColor("#029BCB");
	}
	
	@Listen("onChange = #win1 #colorMenu")
	public void onLeftColorChanged(InputEvent event) {
		win1.setContentStyle("background-color: " + event.getValue());
	}

	@Listen("onChange = #win2 #colorPicker")
	public void onRightColorChanged(Event event) {
		win2.setContentStyle("background-color: " + colorPicker.getColor());
	}
}
