package demo.grid.grouping_model;

import java.util.Comparator;
import java.util.List;

import org.zkoss.zul.GroupsModelArray;

import demo.data.pojo.Food;

public class FoodGroupingModel extends GroupsModelArray<Food, String, String, Object> {
	private static final long serialVersionUID = 1L;
	
	private static final String footerString = "Total %d items";
	
	private boolean showGroup;

	public FoodGroupingModel(List<Food> data, Comparator<Food> cmpr, boolean showGroup) {
		super(data.toArray(new Food[0]), cmpr);
		
		this.showGroup = showGroup;
	}

	protected String createGroupHead(Food[] groupdata, int index, int col) {
		String ret = "";
		if (groupdata.length > 0) {
			ret = groupdata[0].getCategory();
		}

		return ret;
	}

	protected String createGroupFoot(Food[] groupdata, int index, int col) {
		return String.format(footerString, groupdata.length);
	}

	public boolean hasGroupfoot(int groupIndex) {
		boolean retBool = false;
		
		if(showGroup) {
			retBool = super.hasGroupfoot(groupIndex);
		}
		
		return retBool;
	}
}
