package demo.data;

import demo.data.pojo.PackageData;
import org.zkoss.zul.DefaultTreeNode;

public class PackageDataUtil {

    public static DefaultTreeNode<PackageData> getPackageData() {
        return newNode(null,
                newNode(new PackageData("/doc", "Release Notes and License")),
                newNode(new PackageData("/dist", null),
                        newNode(new PackageData("/lib", null),
                                newNode(new PackageData("/zkforge", null),
                                        newNode(new PackageData("ckez.jar", "CKeditor", "1709KB")),
                                        newNode(new PackageData("timelinez.jar", "Timeline", "283KB")),
                                        newNode(new PackageData("timeplotz.jar", "Timeplot", "112KB")),
                                        newNode(new PackageData("gmapsz.jar", "Google Maps", "95KB")),
                                        newNode(new PackageData("zuljsp.jar", "JSP", "129KB"))
                                ),
                                newNode(new PackageData("/ext", null),
                                        newNode(new PackageData("commons-fileupload.jar", "Upload Features")),
                                        newNode(new PackageData("commons-io.jar", "Upload Features")),
                                        newNode(new PackageData("jcommon.jar", "Chart Component")),
                                        newNode(new PackageData("jfreechar.jar", "Chart Component")),
                                        newNode(new PackageData("jasperreports.jar", "Jasperreport related Component")),
                                        newNode(new PackageData("itext.jarjxl.jar", "Jasperreport related Component")),
                                        newNode(new PackageData("poi.jar", "Jasperreport related Component")),
                                        newNode(new PackageData("commons-collections.jar", "Jasperreport related Component")),
                                        newNode(new PackageData("commons-logging.jar", "Jasperreport related Component")),
                                        newNode(new PackageData("commons-digester.jar", "Jasperreport related Component")),
                                        newNode(new PackageData("bsh.jar", "Scripting in Java interpreter for zscript (BeanShell)")),
                                        newNode(new PackageData("js.jar", "Scripting in JavaScript (Rhino)")),
                                        newNode(new PackageData("groovy.jar", "Scripting in Groovy")),
                                        newNode(new PackageData("jruby.jar", "Scripting in Ruby (JRuby)")),
                                        newNode(new PackageData("jython.jar", "Scripting in Python (Jython)")),
                                        newNode(new PackageData("Filters.jar", "Captcha Component.")),
                                        newNode(new PackageData("mvel.jar", "Evaluate the expressions (MVEL)")),
                                        newNode(new PackageData("ognl.jar", "Evaluate the expressions (OGNL)"))
                                ),
                                newNode(new PackageData("zcommon.jar", "ZK Core Jar File", "413KB")),
                                newNode(new PackageData("zcommon-el.jar", "ZK Core Jar File", "100KB")),
                                newNode(new PackageData("zel.jar", "ZK Core Jar File", "151KB")),
                                newNode(new PackageData("zhtml.jar", "ZK Core Jar File", "57KB")),
                                newNode(new PackageData("zml", "ZK Core Jar File", "57KB")),
                                newNode(new PackageData("zk.jar", "ZK Core Jar File", "1056KB")),
                                newNode(new PackageData("zkbind.jar", "ZK Core Jar File", "270KB")),
                                newNode(new PackageData("zkplus.jar", "ZK Core Jar File", "122KB")),
                                newNode(new PackageData("zul.jar", "ZK Core Jar File", "1311KB")),
                                newNode(new PackageData("zweb.jar", "ZK Core Jar File", "196KB"))
                        ),
                        newNode(new PackageData("/src", "Jar Format Source Code")),
                        newNode(new PackageData("/xsd", "XSD files for Development")),
                        newNode(new PackageData("/WEB-INF", "Configuration Files"))
                )
        );
    }

    private static DefaultTreeNode<PackageData> newNode(PackageData data, DefaultTreeNode<PackageData>... children) {
        if (children == null || children.length == 0) {
            return new DefaultTreeNode<>(data);
        }
        return new DefaultTreeNode<>(data, children);
    }
}
