package demo.popup.notification;

import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.select.SelectorComposer;
import org.zkoss.zk.ui.select.annotation.Listen;
import org.zkoss.zk.ui.select.annotation.Wire;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zk.ui.util.Notification;
import org.zkoss.zul.Button;
import org.zkoss.zul.Radiogroup;

public class NotificationComposer extends SelectorComposer<Component> {

	@Wire
	private Radiogroup rgType;
	@Wire
	private Button notifTargetBtn;

	@Override
	public void doAfterCompose(Component comp) throws Exception {
		super.doAfterCompose(comp);
	}

	@Listen("onClick = #notifBtn")
	public void notifyBtnClick() {
		Notification.show("You have been notified");
	}

	@Listen("onClick = #notifCloseBtn")
	public void notifyCloseBtnClick() {
		Notification.show("You have been notified", true);
	}

	@Listen("onClick = #notifTargetBtn")
	public void notifyCustomBtnClick() {
		Notification.show("You have been notified", rgType.getSelectedItem().getLabel(),
				notifTargetBtn, "after_start", 2000, false);
	}

}
