package demo.menu.dynamic_fisheye_menu;

import java.awt.image.RenderedImage;

import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.select.SelectorComposer;
import org.zkoss.zk.ui.select.annotation.Listen;
import org.zkoss.zk.ui.select.annotation.Wire;
import org.zkoss.zkex.zul.Colorbox;
import org.zkoss.zkex.zul.Fisheye;
import org.zkoss.zkex.zul.Fisheyebar;
import org.zkoss.zul.Radiogroup;
import org.zkoss.zul.Textbox;

public class DynamicFisheyeMenuConfigController extends
		SelectorComposer<Component> {

	@Wire
	Fisheyebar fisheyebar;
	@Wire
	Textbox fisheyeText;
	@Wire
	Colorbox fontColor;
	@Wire
	Colorbox shadowColor;
	@Wire
	Radiogroup angle;

	private FisheyeRenderer fisheyeRenderer;

	@Override
	public void doAfterCompose(Component comp) throws Exception {
		super.doAfterCompose(comp);
		fisheyeRenderer = new FisheyeRenderer(180, 200) {
			@Override
			protected void onImageRendered(RenderedImage image) {
				Fisheye fisheye = new Fisheye();
				fisheye.setImageContent(image);
				fisheyebar.appendChild(fisheye);
			}
		};
		drawEye();
	}

	@Listen("onChange = #fontColor, #shadowColor, #fisheyeText; onOK = #fisheyeText; onCheck = #angle")
	public void onConfigChanged() {
		drawEye();
	}

	private void drawEye() {
		String drawText = fisheyeText.getValue().length() == 0 ? "ZK Rocks"
				: fisheyeText.getValue();
		double rotationAngle = Double.parseDouble((String) angle
				.getSelectedItem().getValue());

		fisheyebar.getChildren().clear();
		fisheyeRenderer.draw(drawText.length(), drawText, fontColor.getRGB(),
				shadowColor.getRGB(), rotationAngle);
	}
}
