package demo.listbox.advanced_sorting;

import java.io.Serializable;
import java.util.Comparator;

import demo.data.pojo.Contributor;

public class DemoComparator implements Comparator<Object>, Serializable {
	private static final long serialVersionUID = -2127053833562854322L;
	
	private boolean asc = true;
	private int type = 0;

	public DemoComparator(boolean asc, int type) {
		this.asc = asc;
		this.type = type;
	}

	public int getType() {
		return type;
	}

	public void setType(int type) {
		this.type = type;
	}

	@Override
	public int compare(Object o1, Object o2) {
		Contributor contributor1 = (Contributor) o1;
		Contributor contributor2 = (Contributor) o2;
		switch (type) {
		case 1: // Compare Title
			return contributor1.getTitle().compareTo(contributor2.getTitle()) * (asc ? 1 : -1);
		case 2: // Compare First Name
			return contributor1.getFirstName().compareTo(contributor2.getFirstName()) * (asc ? 1 : -1);
		case 3: // Compare Last Name
			return contributor1.getLastName().compareTo(contributor2.getLastName()) * (asc ? 1 : -1);
		case 4: // Compare Extension
			return contributor1.getExtension().compareTo(contributor2.getExtension()) * (asc ? 1 : -1);
		default: // Full Name
			return contributor1.getFullName().compareTo(contributor2.getFullName()) * (asc ? 1 : -1);
		}

	}

}
