package demo.layout.cssgrid;

import org.zkoss.bind.annotation.BindingParam;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.Init;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.ListModelList;

public class CssGridFormVM {

    private ListModelList<Integer> list = new ListModelList<>();
    private int id = 0;

    @Init
    public void init(){
        add();
    }

    @Command
    public void add(){
        list.add(id);
        id++;
    }

    @Command
    public void save(@BindingParam("id") int id){
        Clients.showNotification("saved item ID "+id);
    }

    @Command
    public void del(@BindingParam("id") Integer id){
        list.remove(id);
    }

    public ListModelList<Integer> getList() {
        return list;
    }
}
