package demo.grid.header_and_footer;

import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.CheckEvent;
import org.zkoss.zk.ui.select.SelectorComposer;
import org.zkoss.zk.ui.select.annotation.Listen;
import org.zkoss.zk.ui.select.annotation.Wire;
import org.zkoss.zul.Footer;
import org.zkoss.zul.Grid;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.ListModelList;
import org.zkoss.zul.Radio;

import demo.data.FoodData;
import demo.data.pojo.Food;

public class FoodListController extends SelectorComposer<Component> {
	private static final long serialVersionUID = 1L;

	private Grid foolList;

	@Wire
	private Footer footer_category;

	public void doAfterCompose(Component comp) throws Exception {
		super.doAfterCompose(comp);
		foolList = (Grid) comp;
		foolList.setModel(new ListModelList<Food>(FoodData.getAllFoods()));
		footer_category.setLabel("A Total of " + FoodData.getAllFoods().size() + " Food Items");
	}

	@Listen("onCheck = #categorySelector")
	public void selectCategory(CheckEvent event) {
		String selectedCategory = ((Radio) event.getTarget()).getLabel();
		ListModel<Food> model = null;
		if (selectedCategory.equals("All Food")) {
			model = new ListModelList<Food>(FoodData.getAllFoods());
		} else {
			model = new ListModelList<Food>(FoodData.getFoodsByCategory(selectedCategory));
		}
		foolList.setModel(model);
		footer_category.setLabel("A Total of " + model.getSize() + " Food Items");
	}
}
