package demo.grid.auto_paging;

import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.select.SelectorComposer;
import org.zkoss.zul.ListModelList;

import demo.data.Purchase;
import demo.data.PurchaseData;

public class AutoPagingController extends SelectorComposer<Component>{
	private static final long serialVersionUID = 1L;
	
	private PurchaseData data = new PurchaseData();
	private ListModelList<String> availableItems;
	
	public AutoPagingController(){
		availableItems = new ListModelList<String>(data.getAvailableItems());
	}
	
	public ListModelList<Purchase> getAllPurchases() {
		return new ListModelList<Purchase>(data.getAllPurchases());
	}
	
	public ListModelList<String> getAvailableItems() {
		return availableItems;
	}
}
