package demo.getting_started.tree;

import java.util.LinkedList;
import java.util.List;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.select.SelectorComposer;
import org.zkoss.zk.ui.select.annotation.Listen;
import org.zkoss.zk.ui.select.annotation.Wire;
import org.zkoss.zul.DefaultTreeModel;
import org.zkoss.zul.DefaultTreeNode;
import org.zkoss.zul.Grid;
import org.zkoss.zul.ListModelList;
import org.zkoss.zul.TreeModel;
import org.zkoss.zul.TreeNode;
import demo.getting_started.Car;
import demo.getting_started.CarService;
import demo.getting_started.CarServiceImpl;
import demo.getting_started.Category;

public class CategoryController extends SelectorComposer<Component> {
	private static final long serialVersionUID = 1L;

	private CarService carService = new CarServiceImpl();
	private TreeModel<TreeNode<Category>> categoriesModel;

	@Wire
	private Grid resultGrid;

	public CategoryController() {
		// construct tree nodes by categories
		Category categoryRoot = carService.getCarCategoriesRoot();
		CategoryTreeNode rootNode = constructCategoryTreeNode(categoryRoot);

		// create tree model
		categoriesModel = new DefaultTreeModel<Category>(rootNode);
		((DefaultTreeModel<Category>)categoriesModel).addOpenPath(new int[]{0});
	}

	private CategoryTreeNode constructCategoryTreeNode(Category category) {
		CategoryTreeNode categoryNode = new CategoryTreeNode(category,carService.countByFilter(category.getName()));
		LinkedList<CategoryTreeNode> queue = new LinkedList<CategoryTreeNode>(); // BFS
		queue.add(categoryNode);
		while(!queue.isEmpty()) {
			CategoryTreeNode node = queue.remove();
			for(Category childCategory : node.getData().getChildren()) {
				CategoryTreeNode child = new CategoryTreeNode(childCategory,carService.countByFilter(childCategory.getName()));
				node.add(child);
				queue.add(child);
			}
		}
		CategoryTreeNode rootNode = new CategoryTreeNode(null,-1); // won't show
		rootNode.add(categoryNode);
		return rootNode;
	}

	public TreeModel<TreeNode<Category>> getCategoriesModel() {
		return categoriesModel;
	}

	@Listen("onSelect = #categoriesTree")
	public void displayCars() {
		TreeNode<Category> selectedNode = ((DefaultTreeModel<Category>)categoriesModel).getSelection()
				.iterator().next();
		Category selectedCategory = selectedNode.getData();
		List<Car> cars = carService.queryByFilter(selectedCategory.getName());
		resultGrid.setModel(new ListModelList<Car>(cars));
	}
}
