package demo.event.echo_event;

import java.util.Deque;
import java.util.LinkedList;
import java.util.Set;

import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.select.SelectorComposer;
import org.zkoss.zk.ui.select.annotation.Listen;
import org.zkoss.zk.ui.select.annotation.Wire;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.A;
import org.zkoss.zul.Button;
import org.zkoss.zul.Groupbox;
import org.zkoss.zul.Image;
import org.zkoss.zul.Label;
import org.zkoss.zul.ListModelList;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listcell;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.Timer;

import demo.data.RandomNameDatas;

public class FetchFileController extends SelectorComposer<Component> {
	private static final long serialVersionUID = 2761033708874533783L;

	private static final String PROCESSING_TEXT = "Processing...";

	@Wire
	private Listbox nameList, downList;
	@Wire
	private Button fetchBtn;
	@Wire
	private Groupbox server;
	@Wire
	private Image serverimg;
	@Wire
	private Timer timer;

	private Deque<String> namesToFetch = new LinkedList<String>();
	private ListModelList<String> nameListModel;
	private ListModelList<String> downListModel;

	@Override
	public void doAfterCompose(Component comp) throws Exception {
		super.doAfterCompose(comp);
		initNameList();
		initDownList();
	}

	@Listen("onClick = #fetchBtn")
	public void fetchFileFromServer(Event e) {
		Set<String> selectedNames = nameListModel.getSelection();
		if (selectedNames.isEmpty()) {
			alert("No Name Selected");
			return;
		}
		namesToFetch.addAll(selectedNames);
		nameListModel.removeAll(selectedNames);

		Events.echoEvent("onAddNameEvent", timer, null);

		Clients.showBusy(server, PROCESSING_TEXT + "(" + namesToFetch.size() + ")");
		serverimg.setSrc("/widgets/event/echo_event/img/webserver_busy.png");
	}

	@Listen("onAddNameEvent = #timer")
	public void processingFiles() {
		timer.start();
	}

	@Listen("onTimer = #timer")
	public void fetchingSimulatorTimer() {
		downListModel.add(namesToFetch.pop());

		Clients.showBusy(server, PROCESSING_TEXT + "(" + namesToFetch.size() + ")");
		if (namesToFetch.isEmpty()) {
			timer.stop();
			Clients.clearBusy(server);
			serverimg.setSrc("/widgets/event/echo_event/img/webserver.png");
		}
	}

	private void initDownList() {
		downListModel = new ListModelList<>();
		downList.setModel(downListModel);
		downList.setItemRenderer((Listitem item, String name, int index) -> {
			item.appendChild(new Listcell(name));
			Listcell cell2 = new Listcell();
			cell2.appendChild(new A("Download Profile"));
			item.appendChild(cell2);
		});
	}

	private void initNameList() {
		nameListModel = new ListModelList<>(RandomNameDatas.getNameList(15));
		nameListModel.setMultiple(true);
		nameListModel.addToSelection(nameListModel.get(0));
		nameListModel.addToSelection(nameListModel.get(1));
		nameList.setModel(nameListModel);
	}
}
