package demo.composite;

import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.IdSpace;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.select.Selectors;
import org.zkoss.zk.ui.select.annotation.Listen;
import org.zkoss.zk.ui.select.annotation.Wire;
import org.zkoss.zul.Caption;
import org.zkoss.zul.Div;
import org.zkoss.zul.Groupbox;
import org.zkoss.zul.Image;
import org.zkoss.zul.Label;
import org.zkoss.zul.Textbox;

public class ImageLabel extends Div implements IdSpace {
	private static final long serialVersionUID = 1L;
	@Wire
	private Groupbox item;
	@Wire
	private Image labelImage;
	@Wire
	private Caption titleCaption;
	@Wire
	private Label descLabel;

	public ImageLabel() {
		Executions.createComponents("/widgets/composite/composite_component/ImageLabel.zul", this, null);
		Selectors.wireComponents(this, this, false);
		Selectors.wireEventListeners(this, this);
		labelImage.setWidth("20px");
		labelImage.setHeight("20px");
	}

	public String getImagePath() {
		return labelImage.getSrc();
	}

	public void setImagePath(String imgPath) {
		this.labelImage.setSrc(imgPath);
	}

	public String getTitle() {
		return titleCaption.getLabel();
	}

	public void setTitle(String title) {
		this.titleCaption.setLabel(title);
	}

	public String getDescription() {
		return descLabel.getValue();
	}

	public void setDescription(String description) {
		this.descLabel.setValue(description);
	}

	InplaceEditor itemInplaceEditor;

	@Listen("onClick = #titleCaption")
	public void titleEdit() {
		if (itemInplaceEditor == null) {
			itemInplaceEditor = new InplaceEditor();
			itemInplaceEditor.setParent(item);
		} else {
			itemInplaceEditor.cancelEdit();
		}
	}

	// Editable Area after click the description
	public class InplaceEditor extends Div implements IdSpace {
		private static final long serialVersionUID = 1L;
		@Wire
		private Textbox editTitle, editDesc;
		

		public InplaceEditor() {
			Executions.createComponents("/widgets/composite/composite_component/InplaceEditor.zul", this, null);
			Selectors.wireComponents(this, this, false);
			Selectors.wireEventListeners(this, this);
			editTitle.setValue(getTitle());
			editDesc.setValue(getDescription());
		}

		@Listen("onClick = #submitBtn")
		public void submitTitleUpdate() {
			setTitle(editTitle.getValue());
			setDescription(editDesc.getValue());
			Events.postEvent(new LabelEditEvent());
			cancelEdit();
		}

		@Listen("onClick = #cancelBtn")
		public void cancelEdit() {
			this.detach();
			itemInplaceEditor = null;
		}
	}

	// Customize Event
	public static final String ON_LABEL_EDIT = "onLabelEdit";

	// Editable Event which contains the content of title and description
	public class LabelEditEvent extends Event {
		private static final long serialVersionUID = 1L;

		public LabelEditEvent() {
			super(ON_LABEL_EDIT, ImageLabel.this);
		}

		public String getCurrentTitle() {
			return getTitle();
		}

		public String getCurrentDesc() {
			return getDescription();
		}
	}
}
