package demo.combobox.cascader;

import org.zkoss.zul.DefaultTreeModel;
import org.zkoss.zul.DefaultTreeNode;

import java.util.List;

import static java.util.Arrays.asList;

public class CascaderData {

	public static DefaultTreeModel<MyNodeData> buildModel() {
		return new DefaultTreeModel<>(node("root", asList(
				node("Node-1"),
				node("Node-2", asList(
						node("Node-2.1"),
						node("Node-2.2", asList(
								node("Node-2.2.1"),
								node("Node-2.2.2"),
								node("Node-2.2.3"),
								node("Node-2.2.4"),
								node("Node-2.2.5"))
						),
						node("Node-2.3", asList(
								node("Node-2.3.1"),
								node("Node-2.3.2", asList(
										node("Node-2.3.2.1"),
										node("Node-2.3.2.2"))
								),
								node("Node-2.3.3"))
						),
						node("Node-2.4"))
				),
				node("Node-3"),
				node("Node-4"))
		));
	}

	private static DefaultTreeNode<MyNodeData> node(String label) {
		return new DefaultTreeNode<>(new MyNodeData(label));
	}

	private static DefaultTreeNode<MyNodeData> node(String label, List<DefaultTreeNode<MyNodeData>> children) {
		return new DefaultTreeNode<>(new MyNodeData(label), children);
	}

	public static class MyNodeData {
		private final String label;

		public MyNodeData(String label) {
			this.label = label;
		}

		public String getLabel() {
			return label;
		}

		@Override
		public String toString() {
			return "MyNodeData{" +
					"label='" + label + '\'' +
					'}';
		}
	}

}
