package demo.combobox.cascader;

import demo.combobox.cascader.CascaderData.MyNodeData;
import org.zkoss.util.Converter;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.OpenEvent;
import org.zkoss.zk.ui.event.SelectEvent;
import org.zkoss.zk.ui.select.SelectorComposer;
import org.zkoss.zk.ui.select.annotation.Listen;
import org.zkoss.zk.ui.select.annotation.Wire;
import org.zkoss.zk.ui.util.Notification;
import org.zkoss.zkmax.zul.Cascader;
import org.zkoss.zul.DefaultTreeModel;
import org.zkoss.zul.ItemRenderer;
import org.zkoss.zul.TreeNode;

import java.util.Collection;
import java.util.stream.Collectors;

public class CascaderComposer extends SelectorComposer {

	@Wire
	private Cascader cascader;
	private DefaultTreeModel<MyNodeData> model;

	@Override
	public void doAfterCompose(Component comp) throws Exception {
		super.doAfterCompose(comp);
		cascader.setPlaceholder("select your node");
		model = CascaderData.buildModel();
		cascader.setModel(model);
		cascader.setItemRenderer(itemRenderer());
		cascader.setItemConverter(itemConverter());
	}

	private Converter<Collection<TreeNode<MyNodeData>>, String> itemConverter() {
		return nodePath -> nodePath.stream()
				.map(node -> node.getData().getLabel())
				.collect(Collectors.joining(" > "));
	}

	private ItemRenderer<TreeNode<MyNodeData>> itemRenderer() {
		return (component, data, i) ->
				data.getData().getLabel();
	}

	@Listen("onClick=#selectNodeInModel")
	public void onSelectNodeInModel() {
		model.addSelectionPath(new int[]{1, 2});
	}

	@Listen("onSelect=#cascader")
	public void onCascaderSelect(SelectEvent event) {
		Notification.show("selected item: " +
				event.getSelectedObjects() +
				"<br/><br/>" +
				"selected path: " +
				cascader.getSelectedItems());
	}

}
