package demo.chart.other;

import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;

import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.StandardBarPainter;
import org.jfree.chart.renderer.xy.StandardXYBarPainter;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.zkoss.zkex.zul.impl.JFreeChartEngine;
import org.zkoss.zul.Chart;

import demo.chart.ChartColors;

/*
 * you are able to do many advanced chart customization by extending JFreeChartEngine
 */
public class ChartsEngine extends JFreeChartEngine {
	@Override
	protected boolean prepareJFreeChart(JFreeChart jfchart, Chart chart) {
		
		Plot plot = jfchart.getPlot();
		
		if(plot instanceof CategoryPlot) {
			CategoryPlot catPlot = jfchart.getCategoryPlot();
			CategoryItemRenderer renderer = catPlot.getRenderer();
			
			if(renderer instanceof BarRenderer) {
				BarRenderer barRenderer = (BarRenderer) renderer;
				barRenderer.setBarPainter(new StandardBarPainter());
			}
			
			renderer.setSeriesPaint(0, ChartColors.COLOR_1);
			renderer.setSeriesPaint(1, ChartColors.COLOR_2);
			renderer.setSeriesPaint(2, ChartColors.COLOR_3);
			renderer.setSeriesPaint(3, ChartColors.COLOR_4);
			renderer.setSeriesPaint(4, ChartColors.COLOR_5);
		}
		
		if(plot instanceof XYPlot) {
			XYPlot xyPlot = (XYPlot)plot;
			XYItemRenderer renderer = xyPlot.getRenderer();
			if(renderer instanceof XYBarRenderer) {
				XYBarRenderer barRenderer = (XYBarRenderer) renderer;
				barRenderer.setBarPainter(new StandardXYBarPainter());
			}

			renderer.setSeriesPaint(0, ChartColors.COLOR_1);
			renderer.setSeriesPaint(1, ChartColors.COLOR_2);
			renderer.setSeriesPaint(2, ChartColors.COLOR_3);
			renderer.setSeriesPaint(3, ChartColors.COLOR_4);
			renderer.setSeriesPaint(4, ChartColors.COLOR_5);
		}
		
		if(plot instanceof PiePlot) {
			PiePlot ringPlot = (PiePlot)plot;
			ringPlot.setLabelBackgroundPaint(ChartColors.COLOR_4);
			Paint[] colors = new Paint[] {ChartColors.COLOR_1, ChartColors.COLOR_2, ChartColors.COLOR_3, ChartColors.COLOR_4};
			DefaultDrawingSupplier defaults = new DefaultDrawingSupplier();
			ringPlot.setDrawingSupplier(new DefaultDrawingSupplier(colors, new Paint[]{defaults.getNextFillPaint()}, new Paint[]{defaults.getNextOutlinePaint()}, 
					new Stroke[]{defaults.getNextStroke()}, new Stroke[] {defaults.getNextOutlineStroke()}, new Shape[] {defaults.getNextShape()}));
			ringPlot.setShadowPaint(null);
			ringPlot.setSectionOutlinesVisible(false);
		}
		return false;
	}
}