package demo.chart.other;


import org.zkoss.bind.annotation.BindingParam;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.GlobalCommand;
import org.zkoss.bind.annotation.Init;
import org.zkoss.bind.annotation.NotifyChange;
import org.zkoss.zkex.zul.impl.JFreeChartEngine;
import org.zkoss.zul.ChartModel;



public class ChartsVM {
	
	boolean threeD;
	ChartModel model;
	String type;
	
	String message;
	
	ChartsEngine engine;
	
	@Init
	public void init() {
		type = "wind";
		threeD = false;
		model = ChartData.getModel(type);
		engine = new ChartsEngine();
	}
	
	public String getType() {
		return type;
	}

	public String getMessage(){
		return message;
	}
	
	public boolean isThreeD() {
		return threeD;
	}

	public ChartModel getModel() {
		return model;
	}

	public JFreeChartEngine getEngine() {
		return engine;
	}

	@Command("showMessage") 
	@NotifyChange("message")
	public void onShowMessage(
			@BindingParam("msg") String message){
		this.message = message;
	}

	
	@GlobalCommand("configChanged") 
	@NotifyChange({"threeD","model","type"})
	public void onConfigChanged(
			@BindingParam("threeD") boolean threeD,
			@BindingParam("type") String type){
		this.threeD = threeD;
		this.type = type;
		this.model = ChartData.getModel(type);
	}
}
