package demo.chart.other;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;

import org.zkoss.zul.CategoryModel;
import org.zkoss.zul.ChartModel;
import org.zkoss.zul.PieModel;
import org.zkoss.zul.SimpleCategoryModel;
import org.zkoss.zul.SimplePieModel;
import org.zkoss.zul.SimpleXYModel;
import org.zkoss.zul.SimpleXYZModel;
import org.zkoss.zul.XYModel;
import org.zkoss.zul.XYZModel;

public class ChartData {

	// type to model map
	static HashMap<String,ChartModel> models = new HashMap<String,ChartModel>();
	static {
		int year = Calendar.getInstance().get(Calendar.YEAR) + 1900;
		// Wind Model
		XYZModel windmodel = new SimpleXYZModel();
		// series, date, direction (0-12), force(0-12)
		windmodel.addValue("Wind!", new Long(date(1, 3).getTime()), new Double(0d), new Double(10.0));
		windmodel.addValue("Wind!", new Long(date(1, 4).getTime()), new Double(1d), new Double(8.5));
		windmodel.addValue("Wind!", new Long(date(1, 5).getTime()), new Double(2.0), new Double(10.0));
		windmodel.addValue("Wind!", new Long(date(1, 6).getTime()), new Double(3.0), new Double(10.0));
		windmodel.addValue("Wind!", new Long(date(1, 7).getTime()), new Double(4.0), new Double(7.0));
		windmodel.addValue("Wind!", new Long(date(1, 8).getTime()), new Double(5.0), new Double(10.0));
		windmodel.addValue("Wind!", new Long(date(1, 9).getTime()), new Double(6.0), new Double(8.0));
		windmodel.addValue("Wind!", new Long(date(1, 10).getTime()), new Double(7.0), new Double(11.0));
		windmodel.addValue("Wind!", new Long(date(1, 11).getTime()), new Double(8.0), new Double(10.0));
		windmodel.addValue("Wind!", new Long(date(1, 12).getTime()), new Double(9.0), new Double(11.0));
		windmodel.addValue("Wind!", new Long(date(1, 13).getTime()), new Double(10.0), new Double(3.0));
		windmodel.addValue("Wind!", new Long(date(1, 14).getTime()), new Double(11.0), new Double(9.0));
		windmodel.addValue("Wind!", new Long(date(1, 15).getTime()), new Double(12.0), new Double(11.0));
		windmodel.addValue("Wind!", new Long(date(1, 16).getTime()), new Double(0.0), new Double(0.0));
		models.put("wind", windmodel);

		
		PieModel piemodel = new SimplePieModel();
		piemodel.setValue("C/C++", new Double(21.2));
		piemodel.setValue("VB", new Double(10.2));
		piemodel.setValue("Java", new Double(40.4));
		piemodel.setValue("PHP", new Double(28.2));
		models.put("ring", piemodel);
		
		// XY Model
		XYModel xymodel = new SimpleXYModel();
		xymodel.addValue(year - 1 + "", new Integer(20), new Integer(120));
		xymodel.addValue(year - 1 + "", new Integer(40), new Integer(135));
		xymodel.addValue(year - 1 + "", new Integer(60), new Integer(140));
		xymodel.addValue(year - 1 + "", new Integer(80), new Integer(160));
		xymodel.addValue(year + "", new Integer(30), new Integer(120));
		xymodel.addValue(year + "", new Integer(50), new Integer(135));
		xymodel.addValue(year + "", new Integer(70), new Integer(140));
		xymodel.addValue(year + "", new Integer(90), new Integer(160));
		models.put("scatter", xymodel);
		models.put("area", xymodel);
		models.put("step_area", xymodel);
		models.put("stacked_area", xymodel);
		models.put("histogram", xymodel);

		/* Category Model */
		CategoryModel categorymodel = new SimpleCategoryModel();
		categorymodel.setValue(year - 1 + "", "Q1", new Integer(20));
		categorymodel.setValue(year - 1 + "", "Q2", new Integer(35));
		categorymodel.setValue(year - 1 + "", "Q3", new Integer(40));
		categorymodel.setValue(year - 1 + "", "Q4", new Integer(55));
		categorymodel.setValue(year + "", "Q1", new Integer(40));
		categorymodel.setValue(year + "", "Q2", new Integer(60));
		categorymodel.setValue(year + "", "Q3", new Integer(70));
		categorymodel.setValue(year + "", "Q4", new Integer(90));
		models.put("stacked_bar", categorymodel);
		models.put("stacked_area", categorymodel);
	}
	
	public static ChartModel getModel(String type){
		return models.get(type);
	}

	private static Date date(int month, int day) {
		Calendar calendar = Calendar.getInstance();
		calendar.set(Calendar.MONTH, month - 1);
		calendar.set(Calendar.DAY_OF_MONTH, day);
		return calendar.getTime();
	}

}
