package demo.chart.other;

import java.util.ArrayList;
import java.util.List;

import org.zkoss.bind.annotation.Init;

public class ChartsConfigVM {

	int selectedIndex;
	List<ChartItem> items;

	@Init
	public void init() {
		selectedIndex = 0;
		items = new ArrayList<ChartItem>();
		items.add(new ChartItem("Wind Plot", "wind", false));
		items.add(new ChartItem("Ring Chart", "ring", false));
		items.add(new ChartItem("Stacked Bar Chart", "stacked_bar", false));
		items.add(new ChartItem("Stacked Bar Chart 3D", "stacked_bar", true));
		items.add(new ChartItem("Stacked Area Chart", "stacked_area", false));
		items.add(new ChartItem("Scatter Chart", "scatter", false));
		items.add(new ChartItem("XY Area Chart", "area", false));
		items.add(new ChartItem("Step Area Chart", "step_area", false));
		items.add(new ChartItem("XY Stacked Area Chart", "stacked_area", false));
		items.add(new ChartItem("Histogram Chart", "histogram", false));
	}

	public int getSelectedIndex() {
		return selectedIndex;
	}

	public void setSelectedIndex(int selectedIndex) {
		this.selectedIndex = selectedIndex;
	}
	
	public ChartItem getSelected(){
		if(selectedIndex<0 || selectedIndex>=items.size()) 
			return null;
		return items.get(selectedIndex);
	}

	public List<ChartItem> getItems() {
		return items;
	}

}
