package demo.chart.gantt;

import org.zkoss.bind.annotation.BindingParam;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.GlobalCommand;
import org.zkoss.bind.annotation.Init;
import org.zkoss.bind.annotation.NotifyChange;
import org.zkoss.zul.GanttModel;

public class GanttChartVM {

	GanttModel model;
	GanttChartEngine engine;
	String message;
	
	String category;
	boolean complete;

	@Init
	public void init() {
		engine = new GanttChartEngine();
		model = ChartData.getModel(category = "both", complete = false);
	}

	public GanttChartEngine getEngine() {
		return engine;
	}

	public GanttModel getModel() {
		return model;
	}
	
	public String getMessage() {
		return message;
	}

	@Command("showMessage") 
	@NotifyChange("message")
	public void onShowMessage(
			@BindingParam("msg") String message){
		this.message = message;
	}
	
	@GlobalCommand("configChanged") 
	@NotifyChange({"model","engine"})
	public void onConfigChanged(
			@BindingParam("category") String category,
			@BindingParam("isComplete") Boolean complete,
			@BindingParam("colorSet") Integer colorSet){
		if(category!=null){
			this.category = category;
		}
		if(complete!=null){
			this.complete = complete;
		}
		if(category!=null || complete!=null){
			this.category = category==null?this.category:category;
			this.complete = complete==null?this.complete:complete;
			model = ChartData.getModel(this.category, this.complete);
		}
		if(colorSet!=null){
			engine.setColorSet(colorSet);
		}
	}
}
