package demo.chart.dial;

import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zul.Constraint;

public class NumberConstraint implements Constraint {
	private Integer LowerBound = 0, UpperBound = 0;

	public NumberConstraint(int LowerBound, int UpperBound) {
		this.LowerBound = LowerBound;
		this.UpperBound = UpperBound;
	}

	public void validate(Component comp, Object obj) throws WrongValueException {
		Integer degree = (Integer) obj; // Intbox
		if (obj == null || degree > UpperBound || degree < LowerBound)
			throw new WrongValueException(comp, "Only numbers between " + LowerBound + " and " + UpperBound + " are allowed.");
	}
}
