package demo.chart.dial;

import org.zkoss.bind.annotation.BindingParam;
import org.zkoss.bind.annotation.GlobalCommand;
import org.zkoss.bind.annotation.Init;
import org.zkoss.zul.DialModel;

public class DialChartVM {

	DialModel celsiusModel;
	DialModel fahrenheitModel;
	
	public DialModel getCelsiusModel() {
		return celsiusModel;
	}

	public DialModel getFahrenheitModel() {
		return fahrenheitModel;
	}

	@Init
	public void init() {
		int celsius = 27;
		celsiusModel = ChartData.createCelsiusModel(celsius);
		fahrenheitModel = ChartData.createFahrenheitModel(ChartData.toFahrenhit(celsius));
	}
	
	@GlobalCommand("configChanged") 
	public void onConfigChanged(
			@BindingParam("isCelsius") boolean isCelsius,
			@BindingParam("degree") int degree){
		if(isCelsius){
			celsiusModel.getScale(0).setValue(degree);
			fahrenheitModel.getScale(0).setValue(ChartData.toFahrenhit(degree));
		}else{
			celsiusModel.getScale(0).setValue(ChartData.toCelsius(degree));
			fahrenheitModel.getScale(0).setValue(degree);
		}
	}
}
