package demo.chart.dial;

import org.zkoss.bind.annotation.DependsOn;
import org.zkoss.bind.annotation.Init;


public class DialChartConfigVM {

	int celsius;
	int fahrenheit;
	
	@Init
	public void init() {
		celsius = 27;
		fahrenheit = ChartData.toFahrenhit(celsius);
	}

	@DependsOn("fahrenheit")
	public int getCelsius() {
		return celsius;
	}

	public void setCelsius(int celsius) {
		this.celsius = celsius;
		fahrenheit = ChartData.toFahrenhit(celsius);
	}

	@DependsOn("celsius")
	public int getFahrenheit() {
		return fahrenheit;
	}

	public void setFahrenheit(int fahrenheit) {
		this.fahrenheit = fahrenheit;
		celsius = ChartData.toCelsius(fahrenheit);
	}
}
