package demo.chart.dial;

import java.awt.Color;

import org.zkoss.zul.DialModel;
import org.zkoss.zul.DialModelScale;

import demo.chart.ChartColors;

public class ChartData {

	public static DialModel createCelsiusModel(int value){
		DialModel model = new DialModel();
		DialModelScale scale = model.newScale(-10.0, 60.0, 230, -280, 10.0, 4);
		
		
		//scale's configuration data
		scale.setValue(value);
		scale.setText("Celsius");
		scale.newRange(-10,  0, ChartColors.toHtmlColor(Color.getHSBColor(0.55f, 0.8f, 1)), 0.61, 0.603);
		scale.newRange(  0, 10, ChartColors.toHtmlColor(Color.getHSBColor(0.3f , 0.8f, 1)), 0.61, 0.603);
		scale.newRange( 10, 20, ChartColors.toHtmlColor(Color.getHSBColor(0.18f, 0.8f, 1)), 0.61, 0.603);
		scale.newRange( 20, 30, ChartColors.toHtmlColor(Color.getHSBColor(0.12f, 0.8f, 1)), 0.61, 0.603);
		scale.newRange( 30, 40, ChartColors.toHtmlColor(Color.getHSBColor(0.08f, 0.8f, 1)), 0.61, 0.603);
		scale.newRange( 40, 50, ChartColors.toHtmlColor(Color.getHSBColor(0.05f, 0.8f, 1)), 0.61, 0.603);
		scale.newRange( 50, 60, ChartColors.toHtmlColor(Color.getHSBColor(0.0f , 0.8f, 1)), 0.61, 0.603);
		scale.setTickColor("#FFFFFF");
		scale.setNeedleType("pin");
		scale.setNeedleColor("#FF0000");
		
		model.setFrameFgColor("#808080");
		model.setFrameBgAlpha(255);
		model.setFrameBgColor("#FFFFFF");
		model.setFrameBgColor1("#000000");
		model.setFrameBgColor2("#000000");

		model.setCapRadius(0.1);
		
		model.setGradientDirection("vertical");
		
		return model;
	}

	public static DialModel createFahrenheitModel(int value){
		DialModel model = new DialModel();
		DialModelScale scale = model.newScale(14, 140.0, 230, -280, 18.0, 8);
		
		//scale's configuration data
		scale.setValue(value);
		scale.setText("Fahrenheit");
		scale.newRange( 14,  32, ChartColors.toHtmlColor(Color.getHSBColor(0.55f, 0.8f, 1)), 0.91, 0.903);
		scale.newRange( 32,  50, ChartColors.toHtmlColor(Color.getHSBColor(0.3f , 0.8f, 1)), 0.91, 0.903);
		scale.newRange( 50,  68, ChartColors.toHtmlColor(Color.getHSBColor(0.18f, 0.8f, 1)), 0.91, 0.903);
		scale.newRange( 68,  86, ChartColors.toHtmlColor(Color.getHSBColor(0.12f, 0.8f, 1)), 0.91, 0.903);
		scale.newRange( 86, 104, ChartColors.toHtmlColor(Color.getHSBColor(0.08f, 0.8f, 1)), 0.91, 0.903);
		scale.newRange(104, 122, ChartColors.toHtmlColor(Color.getHSBColor(0.05f, 0.8f, 1)), 0.91, 0.903);
		scale.newRange(122, 140, ChartColors.toHtmlColor(Color.getHSBColor(0.0f , 0.8f, 1)), 0.91, 0.903);
		scale.setTickColor("#000000");
		scale.setNeedleColor("#FF0000");
		
		model.setFrameFgColor("#505050");
		model.setFrameBgAlpha(0);
		model.setFrameBgColor("#DDDDDD");
		model.setFrameBgColor1("#FFFFFF");
		model.setFrameBgColor2("#FFFFFF");
		
		model.setCapRadius(0.06);
		
		model.setGradientDirection("vertical");
		
		return model;
	}

	public static int toFahrenhit(int celsius){
		return Math.round(celsius * 9 / 5 + 32);
	}
	
	public static int toCelsius(int fahrenheit){
		return Math.round((fahrenheit - 32) * 5 / 9);
	}
}
